import numpy as np
import tkinter.filedialog as fd
import numpy.polynomial.polynomial as npp

fname = fd.askopenfilename()
t, r = np.loadtxt(fname, delimiter=',', usecols=(0,1),
                 unpack=True)

x = np.log(r*1000)
y = 1/(t+273.15)

coef = npp.polyfit(x, y, 3)

print(coef)

a, b, c, d = coef

for value in x:
    print(a, b*value, c*value**2, d*value**3)
#    print(f'{a:.3e}', '\t', f'{b*value:.3e}', '\t',
#          f'{c*value**2:.3e}', '\t', f'{d*value**3:.3e}')





